{$keep 'Foundation'}

unit Foundation;

interface

{********************************************************
*
*  Foundation Editor Interface File
*
*  Other Uses Files Needed:  Common
*
*  Notes:  Each call refers to a data control block (DCB),
*          defined as a record.  Calls which return values
*          store the output into the DCB.
*          All calls return an error number.
*
*  Copyright 1992-1993
*  By Lunar Productions
*  All Rights Reserved
*
*********************************************************}

uses
   Common;

const
	F_UNDO          = $0001;
	F_CLIP          = $0002;
	F_CLEAR         = $0004;
	F_PRINT         = $0008;
    F_SELECT        = $0010;
    F_HELPAPPLY     = $0040;
    F_MENUAPPLY     = $0080;
    F_OPENSILENT    = $0100;
    F_OPENDATA      = $0200;
    F_REMSELECTOR   = $0400;
    F_HEXEDIT       = $0800;
    F_SCRIPTEDIT    = $1000;
    F_PAGESETUP     = $2000;
    F_640MODE       = $4000;
    F_ACTIVATE      = $8000;

{new resource manager error numbers }
    resDiskFull = $1E0E;        { Volume is full }
    resInvalidShutDown = $1E0F; { can't shut down ID 401E }
    resNameNotFound = $1E10;    { no resource with given name }
    resBadNameVers = $1E11;     { bad version in rResName resource }
    resDupStartUp = $1E12;      { already started with this ID }
    resInvalidTypeOrID = $1E13; { type or ID is 0 }

{ Resource Type Numbers }
     rIcon = $8001;             { Icon type}
     rPicture = $8002;          { Picture type}
     rControlList = $8003;      { Control list type}
     rControlTemplate = $8004;  { Control template type}
     rC1InputString = $8005;    { GS/OS class 1 input string}
     rPString = $8006;          { Pascal string type}
     rStringList = $8007;       { String list type}
     rMenuBar = $8008;          { MenuBar type}
     rMenu = $8009;             { Menu template}
     rMenuItem = $800A;         { Menu item definition}
     rTextForLETextBox2 = $800B;{ Data for LineEdit LETextBox2 call}
     rCtlDefProc = $800C;       { Control definition procedure type}
     rCtlColorTbl = $800D;      { Color table for control}
     rWindParam1 = $800E;       { Parameters for NewWindow2 call}
     rWindParam2 = $800F;       { Parameters for NewWindow2 call}
     rWindColor = $8010;        { Window Manager color table}
     rTextBlock = $8011;        { Text block}
     rStyleBlock = $8012;       { TextEdit style information}
     rToolStartup = $8013;      { Tool set startup record}
     rResName = $8014;          { Resource name}
     rAlertString = $8015;      { AlertWindow input data}
     rText = $8016;             { Unformatted text}
     rCodeResource = $8017;
     rCDEVCode = $8018;
     rCDEVFlags = $8019;
     rTwoRects = $801A;         { Two rectangles}
     rFileType = $801B;
     rListRef = $801C;          { List member}
     rCString = $801D;          { C string}
     rXCmd = $801E;
     rXFcn = $801F;
     rErrorString = $8020;      { ErrorWindow input data}
     rKTransTable = $8021;      { Keystroke translation table}
     rWString = $8022;
     rC1OutputString = $8023;   { GS/OS class 1 output string}
     rSoundSample = $8024;
     rTERuler = $8025;          { TextEdit ruler information}
     rFSequence = $8026;
     rCursor = $8027;           { Cursor resource type}
     rItemStruct = $8028;
     rVersion = $8029;
     rComment = $802A;
     rBundle = $802B;
     rFinderPath = $802C;
     rPaletteWindow = $802D;
     rTaggedStrings = $802E;
     rPatternList = $802F;
     rRectList = $C001;
     rPrintRecord = $C002;
     rFont = $C003;

type
    typeRec = record
        flags:     integer;
        fileType:  integer;
        auxType:   longint;
        end;

    replyRecord5_0 = record
        good:         boolean;
        fileType:     integer;
        auxFileType:  longint;
        nameVerb:     integer;
        nameRef:      longint;
        pathVerb:     integer;
        pathRef:      longint;
        end;

    replyRecord5_0ptr = ^replyRecord5_0;

    typeList5_0 = record
        numEntries:       integer;
        fileAndAuxTypes:  array [1..10] of typeRec;     (* change array size *)
        end;                                            (*   as needed       *)

    typeList5_0ptr = ^typeList5_0;


    rgnList = record
	    index:	integer;
	    count:  integer;
	    list:  array [1..32] of handle;
	    end;

    rgnListPtr = ^rgnList;
    rgnListHndl = ^rgnListPtr;

{
    The following structures are defined for the Foundation REM entry blocks
    ------------------------------------------------------------------------
    REM_OPEN
}
    fOpenRec = record
        resType:        integer;
        resID:          longint;
        fFlag:          integer;  { = $0200 Data valid, = $0100 Silent }
        Data:           handle;
        wColorPtr:      ptr;
        end;

    fOpenRecPtr = ^fOpenRec;


{
    REM_CLOSE
    REM_WRITE
    REM_PRINT
}

    fCloseRec = record
        resType:        integer;
        resID:          longint;
        fFlag:          integer;  { = $4000 - 640 mode }
        windowPtr:      ptr;
        end;

    fCloseRecPtr = ^fCloseRec;

{
    REM_EVENT
}

    fEventRec = record
        resType:        integer;
        resID:          longint;
        fFlag:          integer;
        taskCode:       integer;
        end;

    fEventRecPtr = ^fEventRec;

{
    REM_ACTIVATE
}

    fActivateRec = record
        resType:        integer;
        resID:          longint;
        fFlag:          integer;    { $8000 bit is activate }
        linkHand:       handle;     { null if no link references }
        end;

    fActivateRecPtr = ^fActivateRec;

{
    REM_GETLINK
}

    fLinkRec = record
        resType:        integer;
        resID:          longint;
        resFileID:      integer;  { null if current workfile }
        linkHand:       handle;
        end;

    fLinkRecPtr = ^fLinkRec;

{
    REM_VIDMODE
}

    fVidModeRec = record
        resType:        integer;
        resID:          longint;
        fFlag:          integer;  {$4000 - 640 mode }
        windowPtr:      ptr;
        wColorPtr:      ptr;
        end;

    fVidModeRecPtr = ^fVidModeRec;

{
    REM_STARTUP
    REM_SHUTDOWN
}
    fStartStopRec = record
        edUserID:       integer;
        edResFileID:    integer;
        shResFileID:    integer;
        fdResFileID:    integer;
        end;

    fStartStopRecPtr = ^fStartStopRec;

VAR
    fEventPtr :     eventRecPtr;
    fWinProc:       longint;
    fUserID:        integer;
    remHelpID:      longint;


PROCEDURE fAddPrivateData2 (winPtr :GrafPortPtr; taskMask: longint; sig: integer; data: Handle; group: integer; rType: integer; id: longint); extern;
FUNCTION  fAddResource2 (rType: integer; id: longint; data: Handle; attr: integer; fid: integer; name: pStringPtr) : longint;  extern;
FUNCTION  fBuildLinkHand2 (hostType: integer; hostID: longint; fid: integer; indexPtr : integerPtr) : Handle;  extern;
FUNCTION  fColorPalette2 (h: integer; v: integer; color: integer; row: integer; col: integer; mode: integer; resID: longint; fid: integer) : integer;  extern;
FUNCTION  fCopyResource2 (rType: integer; oldID: longint; newID: integer; attr: integer; oldFID: integer; newFID: integer; newName: pStringPtr) : longint;  extern;
FUNCTION  fCountResources2 (rType: integer; fid: integer) : longint;  extern;
PROCEDURE fDetachResource2 (rType: integer; id: longint; fid: integer); extern;
PROCEDURE fDisposeLinkHand2 (linkHand: Handle); extern;
FUNCTION  fExtendLinkHand2 (linkHand: Handle; hostType: integer; hostID: longint; resType: integer; resID: longint; indexPtr: integerPtr) : handle; extern;
FUNCTION  fFindHostLink2 (resType: integer; resID: longint; hostTypePtr: integerPtr; hostIDPtr: longintPtr; indexPtr: integerPtr; resCheckPtr: integerPtr) : Handle; extern;
FUNCTION  fGetEditorStatus2 (rType: integer; id: longint) : longint; extern;
FUNCTION  fGetFileName2: Handle; extern;
FUNCTION  fGetIndResource2 (rType: integer; index: longint; fid: integer) : longint;  extern;
FUNCTION  fGetKernalID2: integer;  extern;
FUNCTION  fGetPrivateData2 (winPtr: GrafPortPtr; taskMaskPtr: longintPtr; sigPtr: integerPtr) : Handle;  extern;
FUNCTION  fGetResourceAttr2 (rType: integer; id: longint; fid: integer) : integer;  extern;
PROCEDURE fGetResourceName2 (rType: integer; id: longint; name: pStringPtr);  extern;
FUNCTION  fGetResourceSize2 (rType: integer; id: longint; fid: integer) : longint;  extern;
PROCEDURE fGetStdTypeName2 (rType: integer; name: pStringPtr);  extern;
PROCEDURE fGetWindowTitle2 (rType: integer; id: longint; name: pStringPtr);  extern;
FUNCTION  fLoadFileData2 (replyRecPtr: longint; promptRecPtr: longint; fTypeRecPtr: longint; filterProcPtr: longint) : Handle;  extern;
FUNCTION  fLoadResource2 (rType: integer; id: longint; statePtr: integerPtr; fid: integer; name: pStringPtr) : handle;  extern;
FUNCTION  fLoadScrap2 (rTypePtr: integerPtr; idPtr: longintPtr; scrap: integer; fidPtr: integerPtr) : Handle;  extern;
PROCEDURE fMarquee2 (action: integer; winP: GrafPortPtr; rgnListHand: rgnListHndl); extern;
PROCEDURE fQueryLinkHand2 (index: integer; linkHand: Handle; hostTypePtr: integerPtr; hostIDPtr: longintPtr; resTypePtr: integerPtr; resIDPtr: longintPtr; resCheckPtr: integerPtr; fidPtr: integerPtr);  extern;
PROCEDURE fRelPrivateData2 (winPtr: GrafPortPtr); extern;
PROCEDURE fReleaseResource2 (rType: integer; id: longint; fid: integer); extern;
PROCEDURE fRemoveResource2 (rType: integer; id: longint; fid: integer); extern;
PROCEDURE fRequestEdit2 (rType: integer; id: longint; data: handle; fFlag: integer); extern;
PROCEDURE fResourceConverter2 (rType: integer; procPtr: longint; flag: integer); extern;
PROCEDURE fSaveScrap2 (rType: integer; id: longint; data: handle; scrap: integer); extern;
PROCEDURE fSelectorMenu2 (rType: integer; menuID: longint; menuData: handle; menuCount: integer; fid: integer); extern;
PROCEDURE fSelectorRequest2 (rType: integer; id: longint; menuID: integer); extern;
PROCEDURE fSetPrivateData2 (winPtr: grafPortPtr; taskMask: longint; sig: integer; data: handle); extern;
FUNCTION  fSetResourceAttr2 (rType: integer; id: longint; attr: integer; fid: integer) : integer;  extern;
FUNCTION  fSetResourceID2 (rType: integer; oldID: longint; newID: longint; fid: integer) : longint;  extern;
PROCEDURE fSetResourceName2 (rType: integer; id: longint; name: pStringPtr); extern;
FUNCTION  fSpecialMagic2 (rType: integer; id: longint; data: Handle; action: integer; fid: integer) : Handle; extern;
PROCEDURE fSpinCursor2; extern;
FUNCTION  fUniqueResourceID2 (rType: integer; id: longint; fid: integer) : longint; extern;
PROCEDURE fWriteResource2 (rType: integer; id: longint; fid: integer); extern;

implementation

end.
